"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def update(hub, ctx, old_name: str, new_name: str) -> None:
    r"""
    **Autogenerated function**

    Renames a repository. The repository name must be unique across the calling AWS account. Repository names are limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. The suffix .git is prohibited. For more information about the limits on repository names, see Limits in the AWS CodeCommit User Guide.

    Args:
        old_name(str): The current name of the repository.
        new_name(str): The new name for the repository.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.repository.name.update(
                ctx, old_name=value, new_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.repository.name.update old_name=value, new_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="update_repository_name",
        op_kwargs={"oldName": old_name, "newName": new_name},
    )
