"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    repository_name: str,
    repository_description: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new, empty repository.

    Args:
        repository_name(str): The name of the new repository to be created.  The repository name must be unique across the calling AWS account. Repository names are limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. For more information about the limits on repository names, see Limits in the AWS CodeCommit User Guide. The suffix .git is prohibited. .
        repository_description(str, optional): A comment or description about the new repository.  The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage. . Defaults to None.
        tags(Dict, optional): One or more tag key-value pairs to use when tagging this repository. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.repository.init.create(ctx, repository_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.repository.init.create repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="create_repository",
        op_kwargs={
            "repositoryName": repository_name,
            "repositoryDescription": repository_description,
            "tags": tags,
        },
    )


async def delete(hub, ctx, repository_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a repository. If a specified repository was already deleted, a null repository ID is returned.  Deleting a repository also deletes all associated objects and metadata. After a repository is deleted, all future push calls to the deleted repository fail.

    Args:
        repository_name(str): The name of the repository to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.repository.init.delete(ctx, repository_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.repository.init.delete repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="delete_repository",
        op_kwargs={"repositoryName": repository_name},
    )


async def get(hub, ctx, repository_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a repository.  The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.

    Args:
        repository_name(str): The name of the repository to get information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.repository.init.get(ctx, repository_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.repository.init.get repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="get_repository",
        op_kwargs={"repositoryName": repository_name},
    )


async def list_all(
    hub, ctx, next_token: str = None, sort_by: str = None, order: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about one or more repositories.

    Args:
        next_token(str, optional): An enumeration token that allows the operation to batch the results of the operation. Batch sizes are 1,000 for list repository operations. When the client sends the token back to AWS CodeCommit, another page of 1,000 records is retrieved. Defaults to None.
        sort_by(str, optional): The criteria used to sort the results of a list repositories operation. Defaults to None.
        order(str, optional): The order in which to sort the results of a list repositories operation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.repository.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.repository.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="list_repositories",
        op_kwargs={"nextToken": next_token, "sortBy": sort_by, "order": order},
    )
