"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    approval_rule_template_name: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all repositories associated with the specified approval rule template.

    Args:
        approval_rule_template_name(str): The name of the approval rule template for which you want to list repositories that are associated with that template.
        next_token(str, optional): An enumeration token that, when provided in a request, returns the next batch of the results. Defaults to None.
        max_results(int, optional): A non-zero, non-negative integer used to limit the number of returned results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.repository.for_approval_rule_template.list(
                ctx, approval_rule_template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.repository.for_approval_rule_template.list approval_rule_template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="list_repositories_for_approval_rule_template",
        op_kwargs={
            "approvalRuleTemplateName": approval_rule_template_name,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
