"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def update(
    hub, ctx, repository_name: str, repository_description: str = None
) -> None:
    r"""
    **Autogenerated function**

    Sets or changes the comment or description for a repository.  The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.

    Args:
        repository_name(str): The name of the repository to set or change the comment or description for.
        repository_description(str, optional): The new comment or description for the specified repository. Repository descriptions are limited to 1,000 characters. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.repository.description.update(
                ctx, repository_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.repository.description.update repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="update_repository_description",
        op_kwargs={
            "repositoryName": repository_name,
            "repositoryDescription": repository_description,
        },
    )
