"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, pull_request_id: str, title: str) -> Dict:
    r"""
    **Autogenerated function**

    Replaces the title of a pull request.

    Args:
        pull_request_id(str): The system-generated ID of the pull request. To get this ID, use ListPullRequests.
        title(str): The updated title of the pull request. This replaces the existing title.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.pull_request.title.update(
                ctx, pull_request_id=value, title=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.pull_request.title.update pull_request_id=value, title=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="update_pull_request_title",
        op_kwargs={"pullRequestId": pull_request_id, "title": title},
    )
