"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, pull_request_id: str, pull_request_status: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates the status of a pull request.

    Args:
        pull_request_id(str): The system-generated ID of the pull request. To get this ID, use ListPullRequests.
        pull_request_status(str): The status of the pull request. The only valid operations are to update the status from OPEN to OPEN, OPEN to CLOSED or from CLOSED to CLOSED.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.pull_request.status.update(
                ctx, pull_request_id=value, pull_request_status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.pull_request.status.update pull_request_id=value, pull_request_status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="update_pull_request_status",
        op_kwargs={
            "pullRequestId": pull_request_id,
            "pullRequestStatus": pull_request_status,
        },
    )
