"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, pull_request_id: str, revision_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about whether approval rules have been set aside (overridden) for a pull request, and if so, the Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for the pull request.

    Args:
        pull_request_id(str): The ID of the pull request for which you want to get information about whether approval rules have been set aside (overridden).
        revision_id(str): The system-generated ID of the revision for the pull request. To retrieve the most recent revision ID, use GetPullRequest.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.pull_request.override_state.get(
                ctx, pull_request_id=value, revision_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.pull_request.override_state.get pull_request_id=value, revision_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="get_pull_request_override_state",
        op_kwargs={"pullRequestId": pull_request_id, "revisionId": revision_id},
    )
