"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    title: str,
    targets: List,
    description: str = None,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a pull request in the specified repository.

    Args:
        title(str): The title of the pull request. This title is used to identify the pull request to other users in the repository.
        description(str, optional): A description of the pull request. Defaults to None.
        targets(List): The targets for the pull request, including the source of the code to be reviewed (the source branch) and the destination where the creator of the pull request intends the code to be merged after the pull request is closed (the destination branch).
        client_request_token(str, optional): A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.  The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an idempotency token is created for you. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.pull_request.init.create(
                ctx, title=value, targets=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.pull_request.init.create title=value, targets=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="create_pull_request",
        op_kwargs={
            "title": title,
            "description": description,
            "targets": targets,
            "clientRequestToken": client_request_token,
        },
    )


async def get(hub, ctx, pull_request_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a pull request in a specified repository.

    Args:
        pull_request_id(str): The system-generated ID of the pull request. To get this ID, use ListPullRequests.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.pull_request.init.get(ctx, pull_request_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.pull_request.init.get pull_request_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="get_pull_request",
        op_kwargs={"pullRequestId": pull_request_id},
    )


async def list_all(
    hub,
    ctx,
    repository_name: str,
    author_arn: str = None,
    pull_request_status: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of pull requests for a specified repository. The return list can be refined by pull request status or pull request author ARN.

    Args:
        repository_name(str): The name of the repository for which you want to list pull requests.
        author_arn(str, optional): Optional. The Amazon Resource Name (ARN) of the user who created the pull request. If used, this filters the results to pull requests created by that user. Defaults to None.
        pull_request_status(str, optional): Optional. The status of the pull request. If used, this refines the results to the pull requests that match the specified status. Defaults to None.
        next_token(str, optional): An enumeration token that, when provided in a request, returns the next batch of the results. Defaults to None.
        max_results(int, optional): A non-zero, non-negative integer used to limit the number of returned results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.pull_request.init.list_all(
                ctx, repository_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.pull_request.init.list_all repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="list_pull_requests",
        op_kwargs={
            "repositoryName": repository_name,
            "authorArn": author_arn,
            "pullRequestStatus": pull_request_status,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
