"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    pull_request_id: str,
    pull_request_event_type: str = None,
    actor_arn: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about one or more pull request events.

    Args:
        pull_request_id(str): The system-generated ID of the pull request. To get this ID, use ListPullRequests.
        pull_request_event_type(str, optional): Optional. The pull request event type about which you want to return information. Defaults to None.
        actor_arn(str, optional): The Amazon Resource Name (ARN) of the user whose actions resulted in the event. Examples include updating the pull request with more commits or changing the status of a pull request. Defaults to None.
        next_token(str, optional): An enumeration token that, when provided in a request, returns the next batch of the results. Defaults to None.
        max_results(int, optional): A non-zero, non-negative integer used to limit the number of returned results. The default is 100 events, which is also the maximum number of events that can be returned in a result. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.pull_request.event.describe_all(
                ctx, pull_request_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.pull_request.event.describe_all pull_request_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="describe_pull_request_events",
        op_kwargs={
            "pullRequestId": pull_request_id,
            "pullRequestEventType": pull_request_event_type,
            "actorArn": actor_arn,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
