"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, pull_request_id: str, description: str) -> Dict:
    r"""
    **Autogenerated function**

    Replaces the contents of the description of a pull request.

    Args:
        pull_request_id(str): The system-generated ID of the pull request. To get this ID, use ListPullRequests.
        description(str): The updated content of the description for the pull request. This content replaces the existing description.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.pull_request.description.update(
                ctx, pull_request_id=value, description=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.pull_request.description.update pull_request_id=value, description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="update_pull_request_description",
        op_kwargs={"pullRequestId": pull_request_id, "description": description},
    )
