"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def merge(
    hub, ctx, pull_request_id: str, repository_name: str, source_commit_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the fast-forward merge strategy. If the merge is successful, it closes the pull request.

    Args:
        pull_request_id(str): The system-generated ID of the pull request. To get this ID, use ListPullRequests.
        repository_name(str): The name of the repository where the pull request was created.
        source_commit_id(str, optional): The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.pull_request.by.fast_forward.merge(
                ctx, pull_request_id=value, repository_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.pull_request.by.fast_forward.merge pull_request_id=value, repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="merge_pull_request_by_fast_forward",
        op_kwargs={
            "pullRequestId": pull_request_id,
            "repositoryName": repository_name,
            "sourceCommitId": source_commit_id,
        },
    )
