"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, pull_request_id: str, revision_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the approval states for a specified pull request. Approval states only apply to pull requests that have one or more approval rules applied to them.

    Args:
        pull_request_id(str): The system-generated ID for the pull request.
        revision_id(str): The system-generated ID for the pull request revision.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.pull_request.approval.state.get_all(
                ctx, pull_request_id=value, revision_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.pull_request.approval.state.get_all pull_request_id=value, revision_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="get_pull_request_approval_states",
        op_kwargs={"pullRequestId": pull_request_id, "revisionId": revision_id},
    )


async def update(
    hub, ctx, pull_request_id: str, revision_id: str, approval_state: str
) -> None:
    r"""
    **Autogenerated function**

    Updates the state of a user's approval on a pull request. The user is derived from the signed-in account when the request is made.

    Args:
        pull_request_id(str): The system-generated ID of the pull request.
        revision_id(str): The system-generated ID of the revision.
        approval_state(str): The approval state to associate with the user on the pull request.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.pull_request.approval.state.update(
                ctx, pull_request_id=value, revision_id=value, approval_state=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.pull_request.approval.state.update pull_request_id=value, revision_id=value, approval_state=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="update_pull_request_approval_state",
        op_kwargs={
            "pullRequestId": pull_request_id,
            "revisionId": revision_id,
            "approvalState": approval_state,
        },
    )
