"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, pull_request_id: str, approval_rule_name: str, approval_rule_content: str
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an approval rule for a pull request.

    Args:
        pull_request_id(str): The system-generated ID of the pull request for which you want to create the approval rule.
        approval_rule_name(str): The name for the approval rule.
        approval_rule_content(str): The content of the approval rule, including the number of approvals needed and the structure of an approval pool defined for approvals, if any. For more information about approval pools, see the AWS CodeCommit User Guide.  When you create the content of the approval rule, you can specify approvers in an approval pool in one of two ways:    CodeCommitApprovers: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account 123456789012 and Mary_Major, all of the following would be counted as approvals coming from that user:   An IAM user in the account (arn:aws:iam::123456789012:user/Mary_Major)   A federated user identified in IAM as Mary_Major (arn:aws:sts::123456789012:federated-user/Mary_Major)   This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of Mary_Major (arn:aws:sts::123456789012:assumed-role/CodeCommitReview/Mary_Major) unless you include a wildcard (*Mary_Major).    Fully qualified ARN: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role.    For more information about IAM ARNs, wildcards, and formats, see IAM Identifiers in the IAM User Guide. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.pull_request.approval.rule.init.create(
                ctx, pull_request_id=value, approval_rule_name=value, approval_rule_content=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.pull_request.approval.rule.init.create pull_request_id=value, approval_rule_name=value, approval_rule_content=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="create_pull_request_approval_rule",
        op_kwargs={
            "pullRequestId": pull_request_id,
            "approvalRuleName": approval_rule_name,
            "approvalRuleContent": approval_rule_content,
        },
    )


async def delete(hub, ctx, pull_request_id: str, approval_rule_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an approval rule from a specified pull request. Approval rules can be deleted from a pull request only if the pull request is open, and if the approval rule was created specifically for a pull request and not generated from an approval rule template associated with the repository where the pull request was created. You cannot delete an approval rule from a merged or closed pull request.

    Args:
        pull_request_id(str): The system-generated ID of the pull request that contains the approval rule you want to delete.
        approval_rule_name(str): The name of the approval rule you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.pull_request.approval.rule.init.delete(
                ctx, pull_request_id=value, approval_rule_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.pull_request.approval.rule.init.delete pull_request_id=value, approval_rule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="delete_pull_request_approval_rule",
        op_kwargs={
            "pullRequestId": pull_request_id,
            "approvalRuleName": approval_rule_name,
        },
    )


async def evaluate(hub, ctx, pull_request_id: str, revision_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Evaluates whether a pull request has met all the conditions specified in its associated approval rules.

    Args:
        pull_request_id(str): The system-generated ID of the pull request you want to evaluate.
        revision_id(str): The system-generated ID for the pull request revision. To retrieve the most recent revision ID for a pull request, use GetPullRequest.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.pull_request.approval.rule.init.evaluate(
                ctx, pull_request_id=value, revision_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.pull_request.approval.rule.init.evaluate pull_request_id=value, revision_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="evaluate_pull_request_approval_rules",
        op_kwargs={"pullRequestId": pull_request_id, "revisionId": revision_id},
    )


async def override(
    hub, ctx, pull_request_id: str, revision_id: str, override_status: str
) -> None:
    r"""
    **Autogenerated function**

    Sets aside (overrides) all approval rule requirements for a specified pull request.

    Args:
        pull_request_id(str): The system-generated ID of the pull request for which you want to override all approval rule requirements. To get this information, use GetPullRequest.
        revision_id(str): The system-generated ID of the most recent revision of the pull request. You cannot override approval rules for anything but the most recent revision of a pull request. To get the revision ID, use GetPullRequest.
        override_status(str): Whether you want to set aside approval rule requirements for the pull request (OVERRIDE) or revoke a previous override and apply approval rule requirements (REVOKE). REVOKE status is not stored.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.pull_request.approval.rule.init.override(
                ctx, pull_request_id=value, revision_id=value, override_status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.pull_request.approval.rule.init.override pull_request_id=value, revision_id=value, override_status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="override_pull_request_approval_rules",
        op_kwargs={
            "pullRequestId": pull_request_id,
            "revisionId": revision_id,
            "overrideStatus": override_status,
        },
    )
