"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub,
    ctx,
    pull_request_id: str,
    approval_rule_name: str,
    new_rule_content: str,
    existing_rule_content_sha256: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the structure of an approval rule created specifically for a pull request. For example, you can change the number of required approvers and the approval pool for approvers.

    Args:
        pull_request_id(str): The system-generated ID of the pull request.
        approval_rule_name(str): The name of the approval rule you want to update.
        existing_rule_content_sha256(str, optional): The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by using GetPullRequest. Defaults to None.
        new_rule_content(str): The updated content for the approval rule.  When you update the content of the approval rule, you can specify approvers in an approval pool in one of two ways:    CodeCommitApprovers: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account 123456789012 and Mary_Major, all of the following are counted as approvals coming from that user:   An IAM user in the account (arn:aws:iam::123456789012:user/Mary_Major)   A federated user identified in IAM as Mary_Major (arn:aws:sts::123456789012:federated-user/Mary_Major)   This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of Mary_Major (arn:aws:sts::123456789012:assumed-role/CodeCommitReview/Mary_Major) unless you include a wildcard (*Mary_Major).    Fully qualified ARN: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role.    For more information about IAM ARNs, wildcards, and formats, see IAM Identifiers in the IAM User Guide. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.pull_request.approval.rule.content.update(
                ctx, pull_request_id=value, approval_rule_name=value, new_rule_content=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.pull_request.approval.rule.content.update pull_request_id=value, approval_rule_name=value, new_rule_content=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="update_pull_request_approval_rule_content",
        op_kwargs={
            "pullRequestId": pull_request_id,
            "approvalRuleName": approval_rule_name,
            "existingRuleContentSha256": existing_rule_content_sha256,
            "newRuleContent": new_rule_content,
        },
    )
