"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    repository_name: str,
    source_commit_specifier: str,
    destination_commit_specifier: str,
    conflict_detail_level: str = None,
    conflict_resolution_strategy: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the merge options available for merging two specified branches. For details about why a merge option is not available, use GetMergeConflicts or DescribeMergeConflicts.

    Args:
        repository_name(str): The name of the repository that contains the commits about which you want to get merge options.
        source_commit_specifier(str): The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).
        destination_commit_specifier(str): The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).
        conflict_detail_level(str, optional): The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line. Defaults to None.
        conflict_resolution_strategy(str, optional): Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.merge.option.get_all(
                ctx,
                repository_name=value,
                source_commit_specifier=value,
                destination_commit_specifier=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.merge.option.get_all repository_name=value, source_commit_specifier=value, destination_commit_specifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="get_merge_options",
        op_kwargs={
            "repositoryName": repository_name,
            "sourceCommitSpecifier": source_commit_specifier,
            "destinationCommitSpecifier": destination_commit_specifier,
            "conflictDetailLevel": conflict_detail_level,
            "conflictResolutionStrategy": conflict_resolution_strategy,
        },
    )
