"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    repository_name: str,
    destination_commit_specifier: str,
    source_commit_specifier: str,
    merge_option: str,
    file_path: str,
    max_merge_hunks: int = None,
    conflict_detail_level: str = None,
    conflict_resolution_strategy: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the squash or three-way merge strategy. If the merge option for the attempted merge is specified as FAST_FORWARD_MERGE, an exception is thrown.

    Args:
        repository_name(str): The name of the repository where you want to get information about a merge conflict.
        destination_commit_specifier(str): The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).
        source_commit_specifier(str): The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).
        merge_option(str): The merge option or strategy you want to use to merge the code.
        max_merge_hunks(int, optional): The maximum number of merge hunks to include in the output. Defaults to None.
        file_path(str): The path of the target files used to describe the conflicts. .
        conflict_detail_level(str, optional): The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line. Defaults to None.
        conflict_resolution_strategy(str, optional): Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful. Defaults to None.
        next_token(str, optional): An enumeration token that, when provided in a request, returns the next batch of the results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.merge.conflict.describe_all(
                ctx,
                repository_name=value,
                destination_commit_specifier=value,
                source_commit_specifier=value,
                merge_option=value,
                file_path=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.merge.conflict.describe_all repository_name=value, destination_commit_specifier=value, source_commit_specifier=value, merge_option=value, file_path=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="describe_merge_conflicts",
        op_kwargs={
            "repositoryName": repository_name,
            "destinationCommitSpecifier": destination_commit_specifier,
            "sourceCommitSpecifier": source_commit_specifier,
            "mergeOption": merge_option,
            "maxMergeHunks": max_merge_hunks,
            "filePath": file_path,
            "conflictDetailLevel": conflict_detail_level,
            "conflictResolutionStrategy": conflict_resolution_strategy,
            "nextToken": next_token,
        },
    )


async def get_all(
    hub,
    ctx,
    repository_name: str,
    destination_commit_specifier: str,
    source_commit_specifier: str,
    merge_option: str,
    conflict_detail_level: str = None,
    max_conflict_files: int = None,
    conflict_resolution_strategy: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about merge conflicts between the before and after commit IDs for a pull request in a repository.

    Args:
        repository_name(str): The name of the repository where the pull request was created.
        destination_commit_specifier(str): The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).
        source_commit_specifier(str): The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).
        merge_option(str): The merge option or strategy you want to use to merge the code. .
        conflict_detail_level(str, optional): The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line. Defaults to None.
        max_conflict_files(int, optional): The maximum number of files to include in the output. Defaults to None.
        conflict_resolution_strategy(str, optional): Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful. Defaults to None.
        next_token(str, optional): An enumeration token that, when provided in a request, returns the next batch of the results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.merge.conflict.get_all(
                ctx,
                repository_name=value,
                destination_commit_specifier=value,
                source_commit_specifier=value,
                merge_option=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.merge.conflict.get_all repository_name=value, destination_commit_specifier=value, source_commit_specifier=value, merge_option=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="get_merge_conflicts",
        op_kwargs={
            "repositoryName": repository_name,
            "destinationCommitSpecifier": destination_commit_specifier,
            "sourceCommitSpecifier": source_commit_specifier,
            "mergeOption": merge_option,
            "conflictDetailLevel": conflict_detail_level,
            "maxConflictFiles": max_conflict_files,
            "conflictResolutionStrategy": conflict_resolution_strategy,
            "nextToken": next_token,
        },
    )
