"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, repository_names: List) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about one or more repositories.  The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.

    Args:
        repository_names(List): The names of the repositories to get information about.  The length constraint limit is for each string in the array. The array itself can be empty. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.get.repository.batch(ctx, repository_names=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.get.repository.batch repository_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="batch_get_repositories",
        op_kwargs={"repositoryNames": repository_names},
    )
