"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, commit_ids: List, repository_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the contents of one or more commits in a repository.

    Args:
        commit_ids(List): The full commit IDs of the commits to get information about.  You must supply the full SHA IDs of each commit. You cannot use shortened SHA IDs. .
        repository_name(str): The name of the repository that contains the commits.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.get.commit.batch(
                ctx, commit_ids=value, repository_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.get.commit.batch commit_ids=value, repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="batch_get_commits",
        op_kwargs={"commitIds": commit_ids, "repositoryName": repository_name},
    )
