"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, repository_name: str, folder_path: str, commit_specifier: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the contents of a specified folder in a repository.

    Args:
        repository_name(str): The name of the repository.
        commit_specifier(str, optional): A fully qualified reference used to identify a commit that contains the version of the folder's content to return. A fully qualified reference can be a commit ID, branch name, tag, or reference such as HEAD. If no specifier is provided, the folder content is returned as it exists in the HEAD commit. Defaults to None.
        folder_path(str): The fully qualified path to the folder whose contents are returned, including the folder name. For example, /examples is a fully-qualified path to a folder named examples that was created off of the root directory (/) of a repository. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.folder.get(
                ctx, repository_name=value, folder_path=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.folder.get repository_name=value, folder_path=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="get_folder",
        op_kwargs={
            "repositoryName": repository_name,
            "commitSpecifier": commit_specifier,
            "folderPath": folder_path,
        },
    )
