"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(
    hub,
    ctx,
    repository_name: str,
    branch_name: str,
    file_path: str,
    parent_commit_id: str,
    keep_empty_folders: bool = None,
    commit_message: str = None,
    name: str = None,
    email: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a specified file from a specified branch. A commit is created on the branch that contains the revision. The file still exists in the commits earlier to the commit that contains the deletion.

    Args:
        repository_name(str): The name of the repository that contains the file to delete.
        branch_name(str): The name of the branch where the commit that deletes the file is made.
        file_path(str): The fully qualified path to the file that to be deleted, including the full name and extension of that file. For example, /examples/file.md is a fully qualified path to a file named file.md in a folder named examples.
        parent_commit_id(str): The ID of the commit that is the tip of the branch where you want to create the commit that deletes the file. This must be the HEAD commit for the branch. The commit that deletes the file is created from this commit ID.
        keep_empty_folders(bool, optional): If a file is the only object in the folder or directory, specifies whether to delete the folder or directory that contains the file. By default, empty folders are deleted. This includes empty folders that are part of the directory structure. For example, if the path to a file is dir1/dir2/dir3/dir4, and dir2 and dir3 are empty, deleting the last file in dir4 also deletes the empty folders dir4, dir3, and dir2. Defaults to None.
        commit_message(str, optional): The commit message you want to include as part of deleting the file. Commit messages are limited to 256 KB. If no message is specified, a default message is used. Defaults to None.
        name(str, optional): The name of the author of the commit that deletes the file. If no name is specified, the user's ARN is used as the author name and committer name. Defaults to None.
        email(str, optional): The email address for the commit that deletes the file. If no email address is specified, the email address is left blank. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.file.delete(
                ctx,
                repository_name=value,
                branch_name=value,
                file_path=value,
                parent_commit_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.file.delete repository_name=value, branch_name=value, file_path=value, parent_commit_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="delete_file",
        op_kwargs={
            "repositoryName": repository_name,
            "branchName": branch_name,
            "filePath": file_path,
            "parentCommitId": parent_commit_id,
            "keepEmptyFolders": keep_empty_folders,
            "commitMessage": commit_message,
            "name": name,
            "email": email,
        },
    )


async def get(
    hub, ctx, repository_name: str, file_path: str, commit_specifier: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the base-64 encoded contents of a specified file and its metadata.

    Args:
        repository_name(str): The name of the repository that contains the file.
        commit_specifier(str, optional): The fully quaified reference that identifies the commit that contains the file. For example, you can specify a full commit ID, a tag, a branch name, or a reference such as refs/heads/master. If none is provided, the head commit is used. Defaults to None.
        file_path(str): The fully qualified path to the file, including the full name and extension of the file. For example, /examples/file.md is the fully qualified path to a file named file.md in a folder named examples.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.file.get(ctx, repository_name=value, file_path=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.file.get repository_name=value, file_path=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="get_file",
        op_kwargs={
            "repositoryName": repository_name,
            "commitSpecifier": commit_specifier,
            "filePath": file_path,
        },
    )


async def put(
    hub,
    ctx,
    repository_name: str,
    branch_name: str,
    file_content: bytes,
    file_path: str,
    file_mode: str = None,
    parent_commit_id: str = None,
    commit_message: str = None,
    name: str = None,
    email: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds or updates a file in a branch in an AWS CodeCommit repository, and generates a commit for the addition in the specified branch.

    Args:
        repository_name(str): The name of the repository where you want to add or update the file.
        branch_name(str): The name of the branch where you want to add or update the file. If this is an empty repository, this branch is created.
        file_content(bytes): The content of the file, in binary object format. .
        file_path(str): The name of the file you want to add or update, including the relative path to the file in the repository.  If the path does not currently exist in the repository, the path is created as part of adding the file. .
        file_mode(str, optional): The file mode permissions of the blob. Valid file mode permissions are listed here. Defaults to None.
        parent_commit_id(str, optional): The full commit ID of the head commit in the branch where you want to add or update the file. If this is an empty repository, no commit ID is required. If this is not an empty repository, a commit ID is required.  The commit ID must match the ID of the head commit at the time of the operation. Otherwise, an error occurs, and the file is not added or updated. Defaults to None.
        commit_message(str, optional): A message about why this file was added or updated. Although it is optional, a message makes the commit history for your repository more useful. Defaults to None.
        name(str, optional): The name of the person adding or updating the file. Although it is optional, a name makes the commit history for your repository more useful. Defaults to None.
        email(str, optional): An email address for the person adding or updating the file. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.file.put(
                ctx, repository_name=value, branch_name=value, file_content=value, file_path=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.file.put repository_name=value, branch_name=value, file_content=value, file_path=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="put_file",
        op_kwargs={
            "repositoryName": repository_name,
            "branchName": branch_name,
            "fileContent": file_content,
            "filePath": file_path,
            "fileMode": file_mode,
            "parentCommitId": parent_commit_id,
            "commitMessage": commit_message,
            "name": name,
            "email": email,
        },
    )
