"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    repository_name: str,
    after_commit_specifier: str,
    before_commit_specifier: str = None,
    before_path: str = None,
    after_path: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the differences in a valid commit specifier (such as a branch, tag, HEAD, commit ID, or other fully qualified reference). Results can be limited to a specified path.

    Args:
        repository_name(str): The name of the repository where you want to get differences.
        before_commit_specifier(str, optional): The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, the full commit ID). Optional. If not specified, all changes before the afterCommitSpecifier value are shown. If you do not use beforeCommitSpecifier in your request, consider limiting the results with maxResults. Defaults to None.
        after_commit_specifier(str): The branch, tag, HEAD, or other fully qualified reference used to identify a commit.
        before_path(str, optional): The file path in which to check for differences. Limits the results to this path. Can also be used to specify the previous name of a directory or folder. If beforePath and afterPath are not specified, differences are shown for all paths. Defaults to None.
        after_path(str, optional): The file path in which to check differences. Limits the results to this path. Can also be used to specify the changed name of a directory or folder, if it has changed. If not specified, differences are shown for all paths. Defaults to None.
        max_results(int, optional): A non-zero, non-negative integer used to limit the number of returned results. Defaults to None.
        next_token(str, optional): An enumeration token that, when provided in a request, returns the next batch of the results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.difference.get_all(
                ctx, repository_name=value, after_commit_specifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.difference.get_all repository_name=value, after_commit_specifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="get_differences",
        op_kwargs={
            "repositoryName": repository_name,
            "beforeCommitSpecifier": before_commit_specifier,
            "afterCommitSpecifier": after_commit_specifier,
            "beforePath": before_path,
            "afterPath": after_path,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
