"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub,
    ctx,
    repository_name: str,
    destination_commit_specifier: str,
    source_commit_specifier: str,
    merge_option: str,
    max_merge_hunks: int = None,
    max_conflict_files: int = None,
    file_paths: List = None,
    conflict_detail_level: str = None,
    conflict_resolution_strategy: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the squash or three-way merge strategy.

    Args:
        repository_name(str): The name of the repository that contains the merge conflicts you want to review.
        destination_commit_specifier(str): The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).
        source_commit_specifier(str): The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).
        merge_option(str): The merge option or strategy you want to use to merge the code.
        max_merge_hunks(int, optional): The maximum number of merge hunks to include in the output. Defaults to None.
        max_conflict_files(int, optional): The maximum number of files to include in the output. Defaults to None.
        file_paths(List, optional): The path of the target files used to describe the conflicts. If not specified, the default is all conflict files. Defaults to None.
        conflict_detail_level(str, optional): The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line. Defaults to None.
        conflict_resolution_strategy(str, optional): Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful. Defaults to None.
        next_token(str, optional): An enumeration token that, when provided in a request, returns the next batch of the results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.describe_merge_conflict.batch(
                ctx,
                repository_name=value,
                destination_commit_specifier=value,
                source_commit_specifier=value,
                merge_option=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.describe_merge_conflict.batch repository_name=value, destination_commit_specifier=value, source_commit_specifier=value, merge_option=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="batch_describe_merge_conflicts",
        op_kwargs={
            "repositoryName": repository_name,
            "destinationCommitSpecifier": destination_commit_specifier,
            "sourceCommitSpecifier": source_commit_specifier,
            "mergeOption": merge_option,
            "maxMergeHunks": max_merge_hunks,
            "maxConflictFiles": max_conflict_files,
            "filePaths": file_paths,
            "conflictDetailLevel": conflict_detail_level,
            "conflictResolutionStrategy": conflict_resolution_strategy,
            "nextToken": next_token,
        },
    )
