"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def update(hub, ctx, repository_name: str, default_branch_name: str) -> None:
    r"""
    **Autogenerated function**

    Sets or changes the default branch name for the specified repository.  If you use this operation to change the default branch name to the current default branch name, a success message is returned even though the default branch did not change.

    Args:
        repository_name(str): The name of the repository to set or change the default branch for.
        default_branch_name(str): The name of the branch to set as the default.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.default_branch.update(
                ctx, repository_name=value, default_branch_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.default_branch.update repository_name=value, default_branch_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="update_default_branch",
        op_kwargs={
            "repositoryName": repository_name,
            "defaultBranchName": default_branch_name,
        },
    )
