"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    repository_name: str,
    branch_name: str,
    parent_commit_id: str = None,
    author_name: str = None,
    email: str = None,
    commit_message: str = None,
    keep_empty_folders: bool = None,
    put_files: List = None,
    delete_files: List = None,
    set_file_modes: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a commit for a repository on the tip of a specified branch.

    Args:
        repository_name(str): The name of the repository where you create the commit.
        branch_name(str): The name of the branch where you create the commit.
        parent_commit_id(str, optional): The ID of the commit that is the parent of the commit you create. Not required if this is an empty repository. Defaults to None.
        author_name(str, optional): The name of the author who created the commit. This information is used as both the author and committer for the commit. Defaults to None.
        email(str, optional): The email address of the person who created the commit. Defaults to None.
        commit_message(str, optional): The commit message you want to include in the commit. Commit messages are limited to 256 KB. If no message is specified, a default message is used. Defaults to None.
        keep_empty_folders(bool, optional): If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a ..gitkeep file is created for empty folders. The default is false. Defaults to None.
        put_files(List, optional): The files to add or update in this commit. Defaults to None.
        delete_files(List, optional): The files to delete in this commit. These files still exist in earlier commits. Defaults to None.
        set_file_modes(List, optional): The file modes to update for files in this commit. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.commit.create(
                ctx, repository_name=value, branch_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.commit.create repository_name=value, branch_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="create_commit",
        op_kwargs={
            "repositoryName": repository_name,
            "branchName": branch_name,
            "parentCommitId": parent_commit_id,
            "authorName": author_name,
            "email": email,
            "commitMessage": commit_message,
            "keepEmptyFolders": keep_empty_folders,
            "putFiles": put_files,
            "deleteFiles": delete_files,
            "setFileModes": set_file_modes,
        },
    )


async def get(hub, ctx, repository_name: str, commit_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a commit, including commit message and committer information.

    Args:
        repository_name(str): The name of the repository to which the commit was made.
        commit_id(str): The commit ID. Commit IDs are the full SHA ID of the commit.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.commit.get(
                ctx, repository_name=value, commit_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.commit.get repository_name=value, commit_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="get_commit",
        op_kwargs={"repositoryName": repository_name, "commitId": commit_id},
    )
