"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def post(
    hub, ctx, in_reply_to: str, content: str, client_request_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Posts a comment in reply to an existing comment on a comparison between commits or a pull request.

    Args:
        in_reply_to(str): The system-generated ID of the comment to which you want to reply. To get this ID, use GetCommentsForComparedCommit or GetCommentsForPullRequest.
        client_request_token(str, optional): A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token. Defaults to None.
        content(str): The contents of your reply to a comment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.comment.reply.post(
                ctx, in_reply_to=value, content=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.comment.reply.post in_reply_to=value, content=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="post_comment_reply",
        op_kwargs={
            "inReplyTo": in_reply_to,
            "clientRequestToken": client_request_token,
            "content": content,
        },
    )
