"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    comment_id: str,
    reaction_user_arn: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about reactions to a specified comment ID. Reactions from users who have been deleted will not be included in the count.

    Args:
        comment_id(str): The ID of the comment for which you want to get reactions information.
        reaction_user_arn(str, optional): Optional. The Amazon Resource Name (ARN) of the user or identity for which you want to get reaction information. Defaults to None.
        next_token(str, optional): An enumeration token that, when provided in a request, returns the next batch of the results. . Defaults to None.
        max_results(int, optional): A non-zero, non-negative integer used to limit the number of returned results. The default is the same as the allowed maximum, 1,000. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.comment.reaction.get_all(ctx, comment_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.comment.reaction.get_all comment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="get_comment_reactions",
        op_kwargs={
            "commentId": comment_id,
            "reactionUserArn": reaction_user_arn,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def put(hub, ctx, comment_id: str, reaction_value: str) -> None:
    r"""
    **Autogenerated function**

    Adds or updates a reaction to a specified comment for the user whose identity is used to make the request. You can only add or update a reaction for yourself. You cannot add, modify, or delete a reaction for another user.

    Args:
        comment_id(str): The ID of the comment to which you want to add or update a reaction.
        reaction_value(str): The emoji reaction you want to add or update. To remove a reaction, provide a value of blank or null. You can also provide the value of none. For information about emoji reaction values supported in AWS CodeCommit, see the AWS CodeCommit User Guide.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.comment.reaction.put(
                ctx, comment_id=value, reaction_value=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.comment.reaction.put comment_id=value, reaction_value=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="put_comment_reaction",
        op_kwargs={"commentId": comment_id, "reactionValue": reaction_value},
    )
