"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, comment_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the content of a comment made on a change, file, or commit in a repository.   Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a count of reactions from active identities, use GetCommentReactions.

    Args:
        comment_id(str): The unique, system-generated ID of the comment. To get this ID, use GetCommentsForComparedCommit or GetCommentsForPullRequest.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.comment.init.get(ctx, comment_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.comment.init.get comment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="get_comment",
        op_kwargs={"commentId": comment_id},
    )


async def update(hub, ctx, comment_id: str, content: str) -> Dict:
    r"""
    **Autogenerated function**

    Replaces the contents of a comment.

    Args:
        comment_id(str): The system-generated ID of the comment you want to update. To get this ID, use GetCommentsForComparedCommit or GetCommentsForPullRequest.
        content(str): The updated content to replace the existing content of the comment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.comment.init.update(
                ctx, comment_id=value, content=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.comment.init.update comment_id=value, content=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="update_comment",
        op_kwargs={"commentId": comment_id, "content": content},
    )
