"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    pull_request_id: str,
    repository_name: str = None,
    before_commit_id: str = None,
    after_commit_id: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns comments made on a pull request.  Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a count of reactions from active identities, use GetCommentReactions.

    Args:
        pull_request_id(str): The system-generated ID of the pull request. To get this ID, use ListPullRequests.
        repository_name(str, optional): The name of the repository that contains the pull request. Defaults to None.
        before_commit_id(str, optional): The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was created. Defaults to None.
        after_commit_id(str, optional): The full commit ID of the commit in the source branch that was the tip of the branch at the time the comment was made. Defaults to None.
        next_token(str, optional): An enumeration token that, when provided in a request, returns the next batch of the results. Defaults to None.
        max_results(int, optional): A non-zero, non-negative integer used to limit the number of returned results. The default is 100 comments. You can return up to 500 comments with a single request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.comment.for_.pull_request.get(
                ctx, pull_request_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.comment.for_.pull_request.get pull_request_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="get_comments_for_pull_request",
        op_kwargs={
            "pullRequestId": pull_request_id,
            "repositoryName": repository_name,
            "beforeCommitId": before_commit_id,
            "afterCommitId": after_commit_id,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def post(
    hub,
    ctx,
    pull_request_id: str,
    repository_name: str,
    before_commit_id: str,
    after_commit_id: str,
    content: str,
    location: Dict = None,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Posts a comment on a pull request.

    Args:
        pull_request_id(str): The system-generated ID of the pull request. To get this ID, use ListPullRequests.
        repository_name(str): The name of the repository where you want to post a comment on a pull request.
        before_commit_id(str): The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was created.
        after_commit_id(str): The full commit ID of the commit in the source branch that is the current tip of the branch for the pull request when you post the comment.
        location(Dict, optional): The location of the change where you want to post your comment. If no location is provided, the comment is posted as a general comment on the pull request difference between the before commit ID and the after commit ID. Defaults to None.
        content(str): The content of your comment on the change.
        client_request_token(str, optional): A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.comment.for_.pull_request.post(
                ctx,
                pull_request_id=value,
                repository_name=value,
                before_commit_id=value,
                after_commit_id=value,
                content=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.comment.for_.pull_request.post pull_request_id=value, repository_name=value, before_commit_id=value, after_commit_id=value, content=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="post_comment_for_pull_request",
        op_kwargs={
            "pullRequestId": pull_request_id,
            "repositoryName": repository_name,
            "beforeCommitId": before_commit_id,
            "afterCommitId": after_commit_id,
            "location": location,
            "content": content,
            "clientRequestToken": client_request_token,
        },
    )
