"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    repository_name: str,
    after_commit_id: str,
    before_commit_id: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about comments made on the comparison between two commits.  Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a count of reactions from active identities, use GetCommentReactions.

    Args:
        repository_name(str): The name of the repository where you want to compare commits.
        before_commit_id(str, optional): To establish the directionality of the comparison, the full commit ID of the before commit. Defaults to None.
        after_commit_id(str): To establish the directionality of the comparison, the full commit ID of the after commit.
        next_token(str, optional): An enumeration token that when provided in a request, returns the next batch of the results. . Defaults to None.
        max_results(int, optional): A non-zero, non-negative integer used to limit the number of returned results. The default is 100 comments, but you can configure up to 500. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.comment.for_.compared_commit.get(
                ctx, repository_name=value, after_commit_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.comment.for_.compared_commit.get repository_name=value, after_commit_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="get_comments_for_compared_commit",
        op_kwargs={
            "repositoryName": repository_name,
            "beforeCommitId": before_commit_id,
            "afterCommitId": after_commit_id,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def post(
    hub,
    ctx,
    repository_name: str,
    after_commit_id: str,
    content: str,
    before_commit_id: str = None,
    location: Dict = None,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Posts a comment on the comparison between two commits.

    Args:
        repository_name(str): The name of the repository where you want to post a comment on the comparison between commits.
        before_commit_id(str, optional): To establish the directionality of the comparison, the full commit ID of the before commit. Required for commenting on any commit unless that commit is the initial commit. Defaults to None.
        after_commit_id(str): To establish the directionality of the comparison, the full commit ID of the after commit.
        location(Dict, optional): The location of the comparison where you want to comment. Defaults to None.
        content(str): The content of the comment you want to make.
        client_request_token(str, optional): A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.comment.for_.compared_commit.post(
                ctx, repository_name=value, after_commit_id=value, content=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.comment.for_.compared_commit.post repository_name=value, after_commit_id=value, content=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="post_comment_for_compared_commit",
        op_kwargs={
            "repositoryName": repository_name,
            "beforeCommitId": before_commit_id,
            "afterCommitId": after_commit_id,
            "location": location,
            "content": content,
            "clientRequestToken": client_request_token,
        },
    )
