"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, repository_name: str, branch_name: str, commit_id: str
) -> None:
    r"""
    **Autogenerated function**

    Creates a branch in a repository and points the branch to a commit.  Calling the create branch operation does not set a repository's default branch. To do this, call the update default branch operation.

    Args:
        repository_name(str): The name of the repository in which you want to create the new branch.
        branch_name(str): The name of the new branch to create.
        commit_id(str): The ID of the commit to point the new branch to.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.branch.init.create(
                ctx, repository_name=value, branch_name=value, commit_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.branch.init.create repository_name=value, branch_name=value, commit_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="create_branch",
        op_kwargs={
            "repositoryName": repository_name,
            "branchName": branch_name,
            "commitId": commit_id,
        },
    )


async def delete(hub, ctx, repository_name: str, branch_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a branch from a repository, unless that branch is the default branch for the repository.

    Args:
        repository_name(str): The name of the repository that contains the branch to be deleted.
        branch_name(str): The name of the branch to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.branch.init.delete(
                ctx, repository_name=value, branch_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.branch.init.delete repository_name=value, branch_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="delete_branch",
        op_kwargs={"repositoryName": repository_name, "branchName": branch_name},
    )


async def get(hub, ctx, repository_name: str = None, branch_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a repository branch, including its name and the last commit ID.

    Args:
        repository_name(str, optional): The name of the repository that contains the branch for which you want to retrieve information. Defaults to None.
        branch_name(str, optional): The name of the branch for which you want to retrieve information. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.branch.init.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.branch.init.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="get_branch",
        op_kwargs={"repositoryName": repository_name, "branchName": branch_name},
    )


async def list_all(hub, ctx, repository_name: str, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about one or more branches in a repository.

    Args:
        repository_name(str): The name of the repository that contains the branches.
        next_token(str, optional): An enumeration token that allows the operation to batch the results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.branch.init.list_all(ctx, repository_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.branch.init.list_all repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="list_branches",
        op_kwargs={"repositoryName": repository_name, "nextToken": next_token},
    )
