"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def merge(
    hub,
    ctx,
    repository_name: str,
    source_commit_specifier: str,
    destination_commit_specifier: str,
    target_branch: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Merges two branches using the fast-forward merge strategy.

    Args:
        repository_name(str): The name of the repository where you want to merge two branches.
        source_commit_specifier(str): The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).
        destination_commit_specifier(str): The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).
        target_branch(str, optional): The branch where the merge is applied. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.branch.by.fast_forward.merge(
                ctx,
                repository_name=value,
                source_commit_specifier=value,
                destination_commit_specifier=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.branch.by.fast_forward.merge repository_name=value, source_commit_specifier=value, destination_commit_specifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="merge_branches_by_fast_forward",
        op_kwargs={
            "repositoryName": repository_name,
            "sourceCommitSpecifier": source_commit_specifier,
            "destinationCommitSpecifier": destination_commit_specifier,
            "targetBranch": target_branch,
        },
    )
