"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, repository_name: str, blob_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the base-64 encoded content of an individual blob in a repository.

    Args:
        repository_name(str): The name of the repository that contains the blob.
        blob_id(str): The ID of the blob, which is its SHA-1 pointer.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.blob.get(ctx, repository_name=value, blob_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.blob.get repository_name=value, blob_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="get_blob",
        op_kwargs={"repositoryName": repository_name, "blobId": blob_id},
    )
