"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, repository_name: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all approval rule templates that are associated with a specified repository.

    Args:
        repository_name(str): The name of the repository for which you want to list all associated approval rule templates.
        next_token(str, optional): An enumeration token that, when provided in a request, returns the next batch of the results. Defaults to None.
        max_results(int, optional): A non-zero, non-negative integer used to limit the number of returned results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.associated_approval_rule_template_for_repository.list(
                ctx, repository_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.associated_approval_rule_template_for_repository.list repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="list_associated_approval_rule_templates_for_repository",
        op_kwargs={
            "repositoryName": repository_name,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
