"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub, ctx, approval_rule_template_name: str, repository_names: List
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an association between an approval rule template and one or more specified repositories.

    Args:
        approval_rule_template_name(str): The name of the template you want to associate with one or more repositories.
        repository_names(List): The names of the repositories you want to associate with the template.  The length constraint limit is for each string in the array. The array itself can be empty. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.associate.approval_rule_template_with_repository.batch(
                ctx, approval_rule_template_name=value, repository_names=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.associate.approval_rule_template_with_repository.batch approval_rule_template_name=value, repository_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="batch_associate_approval_rule_template_with_repositories",
        op_kwargs={
            "approvalRuleTemplateName": approval_rule_template_name,
            "repositoryNames": repository_names,
        },
    )
