"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def associate(
    hub, ctx, approval_rule_template_name: str, repository_name: str
) -> None:
    r"""
    **Autogenerated function**

    Creates an association between an approval rule template and a specified repository. Then, the next time a pull request is created in the repository where the destination reference (if specified) matches the destination reference (branch) for the pull request, an approval rule that matches the template conditions is automatically created for that pull request. If no destination references are specified in the template, an approval rule that matches the template contents is created for all pull requests in that repository.

    Args:
        approval_rule_template_name(str): The name for the approval rule template. .
        repository_name(str): The name of the repository that you want to associate with the template.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.approval_rule_template.with_repository.associate(
                ctx, approval_rule_template_name=value, repository_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.approval_rule_template.with_repository.associate approval_rule_template_name=value, repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="associate_approval_rule_template_with_repository",
        op_kwargs={
            "approvalRuleTemplateName": approval_rule_template_name,
            "repositoryName": repository_name,
        },
    )
