"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub, ctx, old_approval_rule_template_name: str, new_approval_rule_template_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the name of a specified approval rule template.

    Args:
        old_approval_rule_template_name(str): The current name of the approval rule template.
        new_approval_rule_template_name(str): The new name you want to apply to the approval rule template.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.approval_rule_template.name.update(
                ctx, old_approval_rule_template_name=value, new_approval_rule_template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.approval_rule_template.name.update old_approval_rule_template_name=value, new_approval_rule_template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="update_approval_rule_template_name",
        op_kwargs={
            "oldApprovalRuleTemplateName": old_approval_rule_template_name,
            "newApprovalRuleTemplateName": new_approval_rule_template_name,
        },
    )
