"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def disassociate(
    hub, ctx, approval_rule_template_name: str, repository_name: str
) -> None:
    r"""
    **Autogenerated function**

    Removes the association between a template and a repository so that approval rules based on the template are not automatically created when pull requests are created in the specified repository. This does not delete any approval rules previously created for pull requests through the template association.

    Args:
        approval_rule_template_name(str): The name of the approval rule template to disassociate from a specified repository.
        repository_name(str): The name of the repository you want to disassociate from the template.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.approval_rule_template.from_repository.disassociate(
                ctx, approval_rule_template_name=value, repository_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.approval_rule_template.from_repository.disassociate approval_rule_template_name=value, repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="disassociate_approval_rule_template_from_repository",
        op_kwargs={
            "approvalRuleTemplateName": approval_rule_template_name,
            "repositoryName": repository_name,
        },
    )
