"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub, ctx, approval_rule_template_name: str, approval_rule_template_description: str
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the description for a specified approval rule template.

    Args:
        approval_rule_template_name(str): The name of the template for which you want to update the description.
        approval_rule_template_description(str): The updated description of the approval rule template.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.approval_rule_template.description.update(
                ctx, approval_rule_template_name=value, approval_rule_template_description=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.approval_rule_template.description.update approval_rule_template_name=value, approval_rule_template_description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="update_approval_rule_template_description",
        op_kwargs={
            "approvalRuleTemplateName": approval_rule_template_name,
            "approvalRuleTemplateDescription": approval_rule_template_description,
        },
    )
