"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    project_name: str,
    branch_filter: str = None,
    filter_groups: List = None,
    build_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    For an existing AWS CodeBuild build project that has its source code stored in a GitHub or Bitbucket repository, enables AWS CodeBuild to start rebuilding the source code every time a code change is pushed to the repository.  If you enable webhooks for an AWS CodeBuild project, and the project is used as a build step in AWS CodePipeline, then two identical builds are created for each commit. One build is triggered through webhooks, and one through AWS CodePipeline. Because billing is on a per-build basis, you are billed for both builds. Therefore, if you are using AWS CodePipeline, we recommend that you disable webhooks in AWS CodeBuild. In the AWS CodeBuild console, clear the Webhook box. For more information, see step 5 in Change a Build Project's Settings.

    Args:
        project_name(str): The name of the AWS CodeBuild project.
        branch_filter(str, optional): A regular expression used to determine which repository branches are built when a webhook is triggered. If the name of a branch matches the regular expression, then it is built. If branchFilter is empty, then all branches are built.  It is recommended that you use filterGroups instead of branchFilter.  . Defaults to None.
        filter_groups(List, optional): An array of arrays of WebhookFilter objects used to determine which webhooks are triggered. At least one WebhookFilter in the array must specify EVENT as its type.  For a build to be triggered, at least one filter group in the filterGroups array must pass. For a filter group to pass, each of its filters must pass. . Defaults to None.
        build_type(str, optional): Specifies the type of build this webhook will trigger. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.webhook.create(ctx, project_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.webhook.create project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="create_webhook",
        op_kwargs={
            "projectName": project_name,
            "branchFilter": branch_filter,
            "filterGroups": filter_groups,
            "buildType": build_type,
        },
    )


async def delete(hub, ctx, project_name: str) -> Dict:
    r"""
    **Autogenerated function**

    For an existing AWS CodeBuild build project that has its source code stored in a GitHub or Bitbucket repository, stops AWS CodeBuild from rebuilding the source code every time a code change is pushed to the repository.

    Args:
        project_name(str): The name of the AWS CodeBuild project.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.webhook.delete(ctx, project_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.webhook.delete project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="delete_webhook",
        op_kwargs={"projectName": project_name},
    )


async def update(
    hub,
    ctx,
    project_name: str,
    branch_filter: str = None,
    rotate_secret: bool = None,
    filter_groups: List = None,
    build_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Updates the webhook associated with an AWS CodeBuild build project.    If you use Bitbucket for your repository, rotateSecret is ignored.

    Args:
        project_name(str): The name of the AWS CodeBuild project.
        branch_filter(str, optional): A regular expression used to determine which repository branches are built when a webhook is triggered. If the name of a branch matches the regular expression, then it is built. If branchFilter is empty, then all branches are built.   It is recommended that you use filterGroups instead of branchFilter.  . Defaults to None.
        rotate_secret(bool, optional):  A boolean value that specifies whether the associated GitHub repository's secret token should be updated. If you use Bitbucket for your repository, rotateSecret is ignored. . Defaults to None.
        filter_groups(List, optional):  An array of arrays of WebhookFilter objects used to determine if a webhook event can trigger a build. A filter group must contain at least one EVENT WebhookFilter. . Defaults to None.
        build_type(str, optional): Specifies the type of build this webhook will trigger. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.webhook.update(ctx, project_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.webhook.update project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="update_webhook",
        op_kwargs={
            "projectName": project_name,
            "branchFilter": branch_filter,
            "rotateSecret": rotate_secret,
            "filterGroups": filter_groups,
            "buildType": build_type,
        },
    )
