"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    report_arn: str,
    next_token: str = None,
    max_results: int = None,
    filter_: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of details about test cases for a report.

    Args:
        report_arn(str):  The ARN of the report for which test cases are returned. .
        next_token(str, optional):  During a previous call, the maximum number of items that can be returned is the value specified in maxResults. If there more items in the list, then a unique string called a nextToken is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. . Defaults to None.
        max_results(int, optional):  The maximum number of paginated test cases returned per response. Use nextToken to iterate pages in the list of returned TestCase objects. The default value is 100. . Defaults to None.
        filter_(Dict, optional):  A TestCaseFilter object used to filter the returned reports. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.test_case.describe_all(ctx, report_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.test_case.describe_all report_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="describe_test_cases",
        op_kwargs={
            "reportArn": report_arn,
            "nextToken": next_token,
            "maxResults": max_results,
            "filter": filter_,
        },
    )
