"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"import_": "import"}


async def delete_multiple(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes a set of GitHub, GitHub Enterprise, or Bitbucket source credentials.

    Args:
        arn(str):  The Amazon Resource Name (ARN) of the token.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.source_credential.delete_multiple(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.source_credential.delete_multiple arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="delete_source_credentials",
        op_kwargs={"arn": arn},
    )


async def import_(
    hub,
    ctx,
    token: str,
    server_type: str,
    auth_type: str,
    username: str = None,
    should_overwrite: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Imports the source repository credentials for an AWS CodeBuild project that has its source code stored in a GitHub, GitHub Enterprise, or Bitbucket repository.

    Args:
        username(str, optional):  The Bitbucket username when the authType is BASIC_AUTH. This parameter is not valid for other types of source providers or connections. . Defaults to None.
        token(str):  For GitHub or GitHub Enterprise, this is the personal access token. For Bitbucket, this is the app password. .
        server_type(str):  The source provider used for this project. .
        auth_type(str):  The type of authentication used to connect to a GitHub, GitHub Enterprise, or Bitbucket repository. An OAUTH connection is not supported by the API and must be created using the AWS CodeBuild console. .
        should_overwrite(bool, optional):  Set to false to prevent overwriting the repository source credentials. Set to true to overwrite the repository source credentials. The default value is true. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.source_credential.import(ctx, token=value, server_type=value, auth_type=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.source_credential.import token=value, server_type=value, auth_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="import_source_credentials",
        op_kwargs={
            "username": username,
            "token": token,
            "serverType": server_type,
            "authType": auth_type,
            "shouldOverwrite": should_overwrite,
        },
    )


async def list_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of SourceCredentialsInfo objects.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.source_credential.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.source_credential.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="codebuild", operation="list_source_credentials", op_kwargs={}
    )
