"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, resource_arn: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes a resource policy that is identified by its resource ARN.

    Args:
        resource_arn(str):  The ARN of the resource that is associated with the resource policy. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.resource_policy.delete(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.resource_policy.delete resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="delete_resource_policy",
        op_kwargs={"resourceArn": resource_arn},
    )


async def get(hub, ctx, resource_arn: str) -> Dict:
    r"""
    **Autogenerated function**

     Gets a resource policy that is identified by its resource ARN.

    Args:
        resource_arn(str):  The ARN of the resource that is associated with the resource policy. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.resource_policy.get(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.resource_policy.get resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="get_resource_policy",
        op_kwargs={"resourceArn": resource_arn},
    )


async def put(hub, ctx, policy: str, resource_arn: str) -> Dict:
    r"""
    **Autogenerated function**

     Stores a resource policy for the ARN of a Project or ReportGroup object.

    Args:
        policy(str):  A JSON-formatted resource policy. For more information, see Sharing a Project and Sharing a Report Group in the AWS CodeBuild User Guide. .
        resource_arn(str):  The ARN of the Project or ReportGroup resource you want to associate with a resource policy. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.resource_policy.put(
                ctx, policy=value, resource_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.resource_policy.put policy=value, resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="put_resource_policy",
        op_kwargs={"policy": policy, "resourceArn": resource_arn},
    )
