"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes a report.

    Args:
        arn(str):  The ARN of the report to delete. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.report.init.delete(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.report.init.delete arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="codebuild", operation="delete_report", op_kwargs={"arn": arn}
    )


async def list_all(
    hub,
    ctx,
    sort_order: str = None,
    next_token: str = None,
    max_results: int = None,
    filter_: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of ARNs for the reports in the current AWS account.

    Args:
        sort_order(str, optional):  Specifies the sort order for the list of returned reports. Valid values are:     ASCENDING: return reports in chronological order based on their creation date.     DESCENDING: return reports in the reverse chronological order based on their creation date.   . Defaults to None.
        next_token(str, optional):  During a previous call, the maximum number of items that can be returned is the value specified in maxResults. If there more items in the list, then a unique string called a nextToken is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. . Defaults to None.
        max_results(int, optional):  The maximum number of paginated reports returned per response. Use nextToken to iterate pages in the list of returned Report objects. The default value is 100. . Defaults to None.
        filter_(Dict, optional):  A ReportFilter object used to filter the returned reports. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.report.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.report.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="list_reports",
        op_kwargs={
            "sortOrder": sort_order,
            "nextToken": next_token,
            "maxResults": max_results,
            "filter": filter_,
        },
    )
