"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, name: str, type_: str, export_config: Dict, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

     Creates a report group. A report group contains a collection of reports.

    Args:
        name(str):  The name of the report group. .
        type_(str):  The type of report group. .
        export_config(Dict):  A ReportExportConfig object that contains information about where the report group test results are exported. .
        tags(List, optional):  A list of tag key and value pairs associated with this report group.  These tags are available for use by AWS services that support AWS CodeBuild report group tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.report.group.init.create(
                ctx, name=value, type_=value, export_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.report.group.init.create name=value, type_=value, export_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="create_report_group",
        op_kwargs={
            "name": name,
            "type": type_,
            "exportConfig": export_config,
            "tags": tags,
        },
    )


async def delete(hub, ctx, arn: str, delete_reports: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a report group. Before you delete a report group, you must delete its reports.

    Args:
        arn(str): The ARN of the report group to delete. .
        delete_reports(bool, optional): If true, deletes any reports that belong to a report group before deleting the report group.  If false, you must delete any reports in the report group. Use ListReportsForReportGroup to get the reports in a report group. Use DeleteReport to delete the reports. If you call DeleteReportGroup for a report group that contains one or more reports, an exception is thrown. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.report.group.init.delete(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.report.group.init.delete arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="delete_report_group",
        op_kwargs={"arn": arn, "deleteReports": delete_reports},
    )


async def list_all(
    hub,
    ctx,
    sort_order: str = None,
    sort_by: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Gets a list ARNs for the report groups in the current AWS account.

    Args:
        sort_order(str, optional):  Used to specify the order to sort the list of returned report groups. Valid values are ASCENDING and DESCENDING. . Defaults to None.
        sort_by(str, optional):  The criterion to be used to list build report groups. Valid values include:     CREATED_TIME: List based on when each report group was created.    LAST_MODIFIED_TIME: List based on when each report group was last changed.    NAME: List based on each report group's name.  . Defaults to None.
        next_token(str, optional):  During a previous call, the maximum number of items that can be returned is the value specified in maxResults. If there more items in the list, then a unique string called a nextToken is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. . Defaults to None.
        max_results(int, optional):  The maximum number of paginated report groups returned per response. Use nextToken to iterate pages in the list of returned ReportGroup objects. The default value is 100. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.report.group.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.report.group.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="list_report_groups",
        op_kwargs={
            "sortOrder": sort_order,
            "sortBy": sort_by,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def update(
    hub, ctx, arn: str, export_config: Dict = None, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

     Updates a report group.

    Args:
        arn(str):  The ARN of the report group to update. .
        export_config(Dict, optional):  Used to specify an updated export type. Valid values are:     S3: The report results are exported to an S3 bucket.     NO_EXPORT: The report results are not exported.   . Defaults to None.
        tags(List, optional):  An updated list of tag key and value pairs associated with this report group.  These tags are available for use by AWS services that support AWS CodeBuild report group tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.report.group.init.update(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.report.group.init.update arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="update_report_group",
        op_kwargs={"arn": arn, "exportConfig": export_config, "tags": tags},
    )
