"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    report_group_arn: str,
    next_token: str = None,
    sort_order: str = None,
    max_results: int = None,
    filter_: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of ARNs for the reports that belong to a ReportGroup.

    Args:
        report_group_arn(str):  The ARN of the report group for which you want to return report ARNs. .
        next_token(str, optional):  During a previous call, the maximum number of items that can be returned is the value specified in maxResults. If there more items in the list, then a unique string called a nextToken is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. . Defaults to None.
        sort_order(str, optional):  Use to specify whether the results are returned in ascending or descending order. . Defaults to None.
        max_results(int, optional):  The maximum number of paginated reports in this report group returned per response. Use nextToken to iterate pages in the list of returned Report objects. The default value is 100. . Defaults to None.
        filter_(Dict, optional):  A ReportFilter object used to filter the returned reports. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.report.for_report_group.list(
                ctx, report_group_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.report.for_report_group.list report_group_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="list_reports_for_report_group",
        op_kwargs={
            "reportGroupArn": report_group_arn,
            "nextToken": next_token,
            "sortOrder": sort_order,
            "maxResults": max_results,
            "filter": filter_,
        },
    )
