"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    source: Dict,
    artifacts: Dict,
    environment: Dict,
    service_role: str,
    description: str = None,
    secondary_sources: List = None,
    source_version: str = None,
    secondary_source_versions: List = None,
    secondary_artifacts: List = None,
    cache: Dict = None,
    timeout_in_minutes: int = None,
    queued_timeout_in_minutes: int = None,
    encryption_key: str = None,
    tags: List = None,
    vpc_config: Dict = None,
    badge_enabled: bool = None,
    logs_config: Dict = None,
    file_system_locations: List = None,
    build_batch_config: Dict = None,
    concurrent_build_limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a build project.

    Args:
        name(str): The name of the build project.
        description(str, optional): A description that makes the build project easy to identify. Defaults to None.
        source(Dict): Information about the build input source code for the build project.
        secondary_sources(List, optional): An array of ProjectSource objects. . Defaults to None.
        source_version(str, optional): A version of the build input to be built for this project. If not specified, the latest version is used. If specified, it must be one of:    For AWS CodeCommit: the commit ID, branch, or Git tag to use.   For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format pr/pull-request-ID (for example pr/25). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.   For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.   For Amazon S3: the version ID of the object that represents the build input ZIP file to use.   If sourceVersion is specified at the build level, then that version takes precedence over this sourceVersion (at the project level).  For more information, see Source Version Sample with CodeBuild in the AWS CodeBuild User Guide. . Defaults to None.
        secondary_source_versions(List, optional): An array of ProjectSourceVersion objects. If secondarySourceVersions is specified at the build level, then they take precedence over these secondarySourceVersions (at the project level). . Defaults to None.
        artifacts(Dict): Information about the build output artifacts for the build project.
        secondary_artifacts(List, optional): An array of ProjectArtifacts objects. . Defaults to None.
        cache(Dict, optional): Stores recently used information so that it can be quickly accessed at a later time. Defaults to None.
        environment(Dict): Information about the build environment for the build project.
        service_role(str): The ARN of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
        timeout_in_minutes(int, optional): How long, in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait before it times out any build that has not been marked as completed. The default is 60 minutes. Defaults to None.
        queued_timeout_in_minutes(int, optional): The number of minutes a build is allowed to be queued before it times out. . Defaults to None.
        encryption_key(str, optional): The AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build output artifacts.  You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key.   You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format alias/<alias-name>). . Defaults to None.
        tags(List, optional): A list of tag key and value pairs associated with this build project. These tags are available for use by AWS services that support AWS CodeBuild build project tags. Defaults to None.
        vpc_config(Dict, optional): VpcConfig enables AWS CodeBuild to access resources in an Amazon VPC. Defaults to None.
        badge_enabled(bool, optional): Set this to true to generate a publicly accessible URL for your project's build badge. Defaults to None.
        logs_config(Dict, optional): Information about logs for the build project. These can be logs in Amazon CloudWatch Logs, logs uploaded to a specified S3 bucket, or both. . Defaults to None.
        file_system_locations(List, optional):  An array of ProjectFileSystemLocation objects for a CodeBuild build project. A ProjectFileSystemLocation object specifies the identifier, location, mountOptions, mountPoint, and type of a file system created using Amazon Elastic File System. . Defaults to None.
        build_batch_config(Dict, optional): A ProjectBuildBatchConfig object that defines the batch build options for the project. Defaults to None.
        concurrent_build_limit(int, optional): The maximum number of concurrent builds that are allowed for this project. New builds are only started if the current number of builds is less than or equal to this limit. If the current build count meets this limit, new builds are throttled and are not run. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.project.init.create(
                ctx,
                name=value,
                source=value,
                artifacts=value,
                environment=value,
                service_role=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.project.init.create name=value, source=value, artifacts=value, environment=value, service_role=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="create_project",
        op_kwargs={
            "name": name,
            "description": description,
            "source": source,
            "secondarySources": secondary_sources,
            "sourceVersion": source_version,
            "secondarySourceVersions": secondary_source_versions,
            "artifacts": artifacts,
            "secondaryArtifacts": secondary_artifacts,
            "cache": cache,
            "environment": environment,
            "serviceRole": service_role,
            "timeoutInMinutes": timeout_in_minutes,
            "queuedTimeoutInMinutes": queued_timeout_in_minutes,
            "encryptionKey": encryption_key,
            "tags": tags,
            "vpcConfig": vpc_config,
            "badgeEnabled": badge_enabled,
            "logsConfig": logs_config,
            "fileSystemLocations": file_system_locations,
            "buildBatchConfig": build_batch_config,
            "concurrentBuildLimit": concurrent_build_limit,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes a build project. When you delete a project, its builds are not deleted.

    Args:
        name(str): The name of the build project.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.project.init.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.project.init.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="delete_project",
        op_kwargs={"name": name},
    )


async def list_all(
    hub, ctx, sort_by: str = None, sort_order: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of build project names, with each build project name representing a single build project.

    Args:
        sort_by(str, optional): The criterion to be used to list build project names. Valid values include:    CREATED_TIME: List based on when each build project was created.    LAST_MODIFIED_TIME: List based on when information about each build project was last changed.    NAME: List based on each build project's name.   Use sortOrder to specify in what order to list the build project names based on the preceding criteria. Defaults to None.
        sort_order(str, optional): The order in which to list build projects. Valid values include:    ASCENDING: List in ascending order.    DESCENDING: List in descending order.   Use sortBy to specify the criterion to be used to list build project names. Defaults to None.
        next_token(str, optional): During a previous call, if there are more than 100 items in the list, only the first 100 items are returned, along with a unique string called a nextToken. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.project.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.project.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="list_projects",
        op_kwargs={"sortBy": sort_by, "sortOrder": sort_order, "nextToken": next_token},
    )


async def update(
    hub,
    ctx,
    name: str,
    description: str = None,
    source: Dict = None,
    secondary_sources: List = None,
    source_version: str = None,
    secondary_source_versions: List = None,
    artifacts: Dict = None,
    secondary_artifacts: List = None,
    cache: Dict = None,
    environment: Dict = None,
    service_role: str = None,
    timeout_in_minutes: int = None,
    queued_timeout_in_minutes: int = None,
    encryption_key: str = None,
    tags: List = None,
    vpc_config: Dict = None,
    badge_enabled: bool = None,
    logs_config: Dict = None,
    file_system_locations: List = None,
    build_batch_config: Dict = None,
    concurrent_build_limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Changes the settings of a build project.

    Args:
        name(str): The name of the build project.  You cannot change a build project's name. .
        description(str, optional): A new or replacement description of the build project. Defaults to None.
        source(Dict, optional): Information to be changed about the build input source code for the build project. Defaults to None.
        secondary_sources(List, optional):  An array of ProjectSource objects. . Defaults to None.
        source_version(str, optional):  A version of the build input to be built for this project. If not specified, the latest version is used. If specified, it must be one of:    For AWS CodeCommit: the commit ID, branch, or Git tag to use.   For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format pr/pull-request-ID (for example pr/25). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.   For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.   For Amazon S3: the version ID of the object that represents the build input ZIP file to use.    If sourceVersion is specified at the build level, then that version takes precedence over this sourceVersion (at the project level).   For more information, see Source Version Sample with CodeBuild in the AWS CodeBuild User Guide. . Defaults to None.
        secondary_source_versions(List, optional):  An array of ProjectSourceVersion objects. If secondarySourceVersions is specified at the build level, then they take over these secondarySourceVersions (at the project level). . Defaults to None.
        artifacts(Dict, optional): Information to be changed about the build output artifacts for the build project. Defaults to None.
        secondary_artifacts(List, optional):  An array of ProjectSource objects. . Defaults to None.
        cache(Dict, optional): Stores recently used information so that it can be quickly accessed at a later time. Defaults to None.
        environment(Dict, optional): Information to be changed about the build environment for the build project. Defaults to None.
        service_role(str, optional): The replacement ARN of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account. Defaults to None.
        timeout_in_minutes(int, optional): The replacement value in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait before timing out any related build that did not get marked as completed. Defaults to None.
        queued_timeout_in_minutes(int, optional):  The number of minutes a build is allowed to be queued before it times out. . Defaults to None.
        encryption_key(str, optional): The AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build output artifacts.   You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key.   You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format alias/<alias-name>). . Defaults to None.
        tags(List, optional): An updated list of tag key and value pairs associated with this build project. These tags are available for use by AWS services that support AWS CodeBuild build project tags. Defaults to None.
        vpc_config(Dict, optional): VpcConfig enables AWS CodeBuild to access resources in an Amazon VPC. Defaults to None.
        badge_enabled(bool, optional): Set this to true to generate a publicly accessible URL for your project's build badge. Defaults to None.
        logs_config(Dict, optional):  Information about logs for the build project. A project can create logs in Amazon CloudWatch Logs, logs in an S3 bucket, or both. . Defaults to None.
        file_system_locations(List, optional):  An array of ProjectFileSystemLocation objects for a CodeBuild build project. A ProjectFileSystemLocation object specifies the identifier, location, mountOptions, mountPoint, and type of a file system created using Amazon Elastic File System. . Defaults to None.
        build_batch_config(Dict, optional): Contains configuration information about a batch build project. Defaults to None.
        concurrent_build_limit(int, optional): The maximum number of concurrent builds that are allowed for this project. New builds are only started if the current number of builds is less than or equal to this limit. If the current build count meets this limit, new builds are throttled and are not run. To remove this limit, set this value to -1. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.project.init.update(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.project.init.update name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="update_project",
        op_kwargs={
            "name": name,
            "description": description,
            "source": source,
            "secondarySources": secondary_sources,
            "sourceVersion": source_version,
            "secondarySourceVersions": secondary_source_versions,
            "artifacts": artifacts,
            "secondaryArtifacts": secondary_artifacts,
            "cache": cache,
            "environment": environment,
            "serviceRole": service_role,
            "timeoutInMinutes": timeout_in_minutes,
            "queuedTimeoutInMinutes": queued_timeout_in_minutes,
            "encryptionKey": encryption_key,
            "tags": tags,
            "vpcConfig": vpc_config,
            "badgeEnabled": badge_enabled,
            "logsConfig": logs_config,
            "fileSystemLocations": file_system_locations,
            "buildBatchConfig": build_batch_config,
            "concurrentBuildLimit": concurrent_build_limit,
        },
    )
