"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def invalidate(hub, ctx, project_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Resets the cache for a project.

    Args:
        project_name(str): The name of the AWS CodeBuild build project that the cache is reset for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.project.cache.invalidate(ctx, project_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.project.cache.invalidate project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="invalidate_project_cache",
        op_kwargs={"projectName": project_name},
    )
