"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, report_arns: List) -> Dict:
    r"""
    **Autogenerated function**

     Returns an array of reports.

    Args:
        report_arns(List):  An array of ARNs that identify the Report objects to return. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.get.report.init.batch(ctx, report_arns=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.get.report.init.batch report_arns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="batch_get_reports",
        op_kwargs={"reportArns": report_arns},
    )
