"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, report_group_arns: List) -> Dict:
    r"""
    **Autogenerated function**

     Returns an array of report groups.

    Args:
        report_group_arns(List):  An array of report group ARNs that identify the report groups to return. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.get.report.group.batch(ctx, report_group_arns=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.get.report.group.batch report_group_arns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="batch_get_report_groups",
        op_kwargs={"reportGroupArns": report_group_arns},
    )
