"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, names: List) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about one or more build projects.

    Args:
        names(List): The names or ARNs of the build projects. To get information about a project shared with your AWS account, its ARN must be specified. You cannot specify a shared project using its name.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.get.project.batch(ctx, names=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.get.project.batch names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="batch_get_projects",
        op_kwargs={"names": names},
    )
